/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _wp = wp,
    blocks = _wp.blocks,
    blockEditor = _wp.blockEditor,
    data = _wp.data;
var compose = wp.compose.compose;
var withSelect = data.withSelect;
var registerBlockType = blocks.registerBlockType;
var InnerBlocks = blockEditor.InnerBlocks;


var style = {
  minHeight: '40px',
  margin: '0 -40px',
  padding: '0 40px'
};

var template = [['core/paragraph', {}]];

function SectionEdit() {
  return React.createElement(
    'main',
    { style: style },
    React.createElement(InnerBlocks, { templateLock: false, template: template })
  );
}

var settings = {
  title: Drupal.t('Section'),
  description: Drupal.t('Section block for template use.'),
  icon: 'media-document',
  attributes: {},
  supports: {
    inserter: false,
    align: true,
    html: false
  },

  edit: compose([withSelect(function (select, _ref) {
    var clientId = _ref.clientId;

    var _select = select('core/block-editor'),
        getBlock = _select.getBlock;

    var block = getBlock(clientId);

    return {
      hasInnerBlocks: !!(block && block.innerBlocks.length)
    };
  })])(SectionEdit),

  save: function save(_ref2) {
    var className = _ref2.className;

    return React.createElement(
      'main',
      { className: className },
      React.createElement(InnerBlocks.Content, null)
    );
  }
};

registerBlockType('drupal/section', _extends({ category: 'common' }, settings));