/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

(function (Drupal, wp) {
  var blocks = wp.blocks,
      element = wp.element,
      blockEditor = wp.blockEditor;
  var registerBlockType = blocks.registerBlockType;
  var Fragment = element.Fragment;
  var RichText = blockEditor.RichText;

  var __ = Drupal.t;

  var settings = {
    title: __('Simple text'),
    description: __('Simple text block.'),
    icon: 'editor-textcolor',
    supports: {
      inserter: false
    },
    attributes: {
      tag: {
        type: 'string',
        default: 'p'
      },
      text: {
        type: 'string'
      },
      placeholder: {
        type: 'string',
        default: 'Insert text'
      }
    },

    edit: function edit(_ref) {
      var className = _ref.className,
          attributes = _ref.attributes,
          setAttributes = _ref.setAttributes;
      var text = attributes.text,
          tag = attributes.tag,
          placeholder = attributes.placeholder;

      return React.createElement(
        Fragment,
        null,
        React.createElement(
          'div',
          { className: className },
          React.createElement(RichText, {
            tagName: tag,
            value: text,
            placeholder: placeholder,
            keepPlaceholderOnFocus: true,
            allowedFormats: [],
            onChange: function onChange(newValue) {
              return setAttributes({ text: newValue });
            }
          })
        )
      );
    },
    save: function save(_ref2) {
      var attributes = _ref2.attributes;
      var text = attributes.text;

      return text;
    }
  };

  registerBlockType('drupal/simple-text', _extends({ category: 'common' }, settings));
})(Drupal, wp);