/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

(function (wp, Drupal, moment) {
  var element = wp.element,
      components = wp.components;
  var Component = element.Component,
      Fragment = element.Fragment;
  var TextControl = components.TextControl,
      TextareaControl = components.TextareaControl;

  var customTypes = ['image', 'audio', 'video'];

  function toSize(bytes) {
    var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'];
    var value = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)), 10);
    return Math.round(bytes / Math.pow(1024, value), 2) + ' ' + sizes[value];
  }

  var MediaBrowserDetails = function (_Component) {
    _inherits(MediaBrowserDetails, _Component);

    function MediaBrowserDetails() {
      _classCallCheck(this, MediaBrowserDetails);

      var _this = _possibleConstructorReturn(this, (MediaBrowserDetails.__proto__ || Object.getPrototypeOf(MediaBrowserDetails)).apply(this, arguments));

      var media = _this.props.media;

      _this.state = {
        width: null,
        height: null,
        duration: null,
        title: media.title,
        altText: media.alt,
        caption: media.caption
      };
      _this.updateVideo = _this.updateVideo.bind(_this);
      _this.updateAudio = _this.updateAudio.bind(_this);
      return _this;
    }

    _createClass(MediaBrowserDetails, [{
      key: 'componentDidUpdate',
      value: function componentDidUpdate(prevProps) {
        var onChange = this.props.onChange;
        var _state = this.state,
            title = _state.title,
            altText = _state.altText,
            caption = _state.caption;


        onChange({ title: title, altText: altText, caption: caption });
      }
    }, {
      key: 'updateVideo',
      value: function updateVideo(ev) {
        this.setState({
          width: ev.target.videoWidth,
          height: ev.target.videoHeight,
          duration: moment.unix(ev.target.duration).format('HH:mm:ss')
        });
      }
    }, {
      key: 'updateAudio',
      value: function updateAudio(ev) {
        this.setState({
          duration: moment.unix(ev.target.duration).format('HH:mm:ss')
        });
      }
    }, {
      key: 'render',
      value: function render() {
        var _this2 = this;

        var media = this.props.media;
        var _state2 = this.state,
            width = _state2.width,
            height = _state2.height,
            duration = _state2.duration,
            title = _state2.title,
            altText = _state2.altText,
            caption = _state2.caption;


        return React.createElement(
          Fragment,
          null,
          media.media_type === 'image' && React.createElement(
            Fragment,
            null,
            React.createElement(
              'figure',
              null,
              React.createElement('img', { alt: media.media_details.file, src: media.source_url }),
              React.createElement(
                'figcaption',
                null,
                media.media_details.file
              )
            ),
            React.createElement(
              'div',
              null,
              media.media_details.width + ' x ' + media.media_details.height
            ),
            React.createElement(
              'div',
              null,
              toSize(media.media_details.filesize)
            ),
            React.createElement(TextControl, {
              value: title,
              onChange: function onChange(value) {
                return _this2.setState({ title: value });
              },
              label: 'Title'
            }),
            React.createElement(TextControl, {
              value: altText,
              onChange: function onChange(value) {
                return _this2.setState({ altText: value });
              },
              label: 'Alt text'
            }),
            React.createElement(TextareaControl, {
              value: caption,
              onChange: function onChange(value) {
                return _this2.setState({ caption: value });
              },
              label: 'Caption'
            })
          ),
          media.media_type === 'video' && React.createElement(
            Fragment,
            null,
            React.createElement(
              'figure',
              null,
              React.createElement('video', {
                onLoadedData: this.updateVideo,
                controls: true,
                src: media.source_url
              }),
              React.createElement(
                'figcaption',
                null,
                media.media_details.file
              )
            ),
            React.createElement(
              'div',
              null,
              width + ' x ' + height
            ),
            React.createElement(
              'div',
              null,
              toSize(media.media_details.filesize)
            ),
            React.createElement(
              'div',
              null,
              '' + duration
            )
          ),
          media.media_type === 'audio' && React.createElement(
            Fragment,
            null,
            React.createElement(
              'figure',
              null,
              React.createElement('audio', {
                onLoadedData: this.updateAudio,
                controls: true,
                src: media.source_url
              }),
              React.createElement(
                'figcaption',
                null,
                media.media_details.file
              )
            ),
            React.createElement(
              'div',
              null,
              toSize(media.media_details.filesize)
            ),
            React.createElement(
              'div',
              null,
              '' + duration
            )
          ),
          !customTypes.includes(media.media_type) && React.createElement(
            Fragment,
            null,
            React.createElement(
              'div',
              { className: 'filename' },
              media.media_details.file
            ),
            React.createElement(
              'div',
              null,
              toSize(media.media_details.filesize)
            )
          )
        );
      }
    }]);

    return MediaBrowserDetails;
  }(Component);

  window.DrupalGutenberg = window.DrupalGutenberg || {};
  window.DrupalGutenberg.Components = window.DrupalGutenberg.Components || {};
  window.DrupalGutenberg.Components.MediaBrowserDetails = MediaBrowserDetails;
})(wp, Drupal, moment);