/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/'use strict';

(function (wp) {
  var element = wp.element,
      plugins = wp.plugins,
      editPost = wp.editPost,
      data = wp.data;
  var dispatch = data.dispatch,
      select = data.select;
  var useRef = element.useRef,
      useEffect = element.useEffect;
  var registerPlugin = plugins.registerPlugin;
  var PluginDocumentSettingPanel = editPost.PluginDocumentSettingPanel;


  var FormPanel = function FormPanel() {
    var ref = useRef(null);

    useEffect(function () {
      var editAdvanced = document.getElementById('edit-advanced');
      var sidebar = document.getElementById('gutenberg-sidebar');

      editAdvanced && ref.current.appendChild(editAdvanced);

      return function () {
        editAdvanced && sidebar && sidebar.appendChild(editAdvanced);
      };
    }, []);

    return React.createElement('div', { ref: ref });
  };

  var NodeDocumentSettings = function NodeDocumentSettings() {
    return React.createElement(
      PluginDocumentSettingPanel,
      {
        name: 'panel',
        className: 'node-settings-plugin',
        title: 'Node'
      },
      React.createElement(FormPanel, null)
    );
  };

  registerPlugin('node-document-settings', {
    render: NodeDocumentSettings,
    icon: null
  });

  var isOpened = select('core/edit-post').isEditorPanelOpened('node-document-settings/panel');

  if (!isOpened) {
    dispatch('core/edit-post').toggleEditorPanelOpened('node-document-settings/panel');
  }
})(wp, Drupal);