jQuery(document).ready(function ($) {
  
 // Select all links with hashes
$('a[href*="#"]')
  // Remove links that don't actually link to anything
  .not('[href="#"]')
  .not('[href="#0"]')
  .click(function(event) {
    // On-page links
    if (
      location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') 
      && 
      location.hostname == this.hostname
    ) {
      // Figure out element to scroll to
      var target = $(this.hash);
      target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
      // Does a scroll target exist?
      if (target.length) {
        // Only prevent default if animation is actually gonna happen
        event.preventDefault();
        $('html, body').animate({
          scrollTop: target.offset().top - 60
        }, 1000, function() {
          // Callback after animation
          // Must change focus!
          var $target = $(target);
          $target.focus();
          if ($target.is(":focus")) { // Checking if the target was focused
            return false;
          } else {
            $target.attr('tabindex','-1'); // Adding tabindex for elements not focusable
            $target.focus(); // Set focus again
          };
        });
      }
    }
  });
  
  $(window).on('scroll', function() {
    var scrollTop = $(this).scrollTop();

    $('.paragraph--type--groupe').each(function() {
        var topDistance = $(this).offset().top;

        if ( (topDistance+100) < scrollTop ) {
        var color = $(this).find(".firstcolor").html();
		$("#p43").css("background-color",color);
        }
    });
});

$(window).on("scroll",function() {
	var $height = $(window).scrollTop();
  if($height > 50) {
		$(".p43").addClass("small")
	} else {
		$(".p43").removeClass("small")
	}
});
$(".p47").on("click", function(){
	$("#ancremenu").toggleClass("open");
});

$("#ancremenu a").on("click", function() {
	$("#ancremenu").removeClass("open");
})

/*CURSOR*/
var cursor = $('.cursor');
var follower = $('.follower');
var linker = $('.linker');

function liquidMove(){
    TweenMax.to(follower, Math.random() + 0.6, {x: Math.random() * 30 - 13, y: Math.random() * 30 - 13, ease: Power0.easeNone, onComplete:liquidMove})
    TweenMax.to(linker, Math.random() + 0.6, {x: Math.random() * 30 - 13, y: Math.random() * 30 - 13, ease: Power0.easeNone})
    TweenMax.to(cursor, Math.random() + 0.6, {scaleX: Math.random() + 0.5})
    TweenMax.to(cursor, Math.random() + 0.6, {scaleY: Math.random() + 0.5})
}

liquidMove();


$(document).bind('mousemove', function (e) {
  
    var offset = $(window).scrollTop();
  
    TweenLite.to(cursor, 0, {left: e.pageX - 8, top: e.pageY - offset - 8})
    TweenLite.to(follower, 0.25, {left: e.pageX - 4, top: e.pageY - offset - 4})
    TweenLite.to(linker, 0.35, {left: e.pageX - 2, top: e.pageY - offset - 2})
});

/**** VIDEO POPUP ****/

$(".popup-link").on("click", function() {
	$(this).closest(".popup-wrapp").find(".popup-overlay").clone().appendTo("body").addClass("open");
})

$(document).on("click", ".popup-overlay .close", function() {
	$(this).closest(".popup-overlay").remove();
})




  
});