/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

(function (Drupal, wp) {
  var blocks = wp.blocks,
      data = wp.data,
      element = wp.element,
      blockEditor = wp.blockEditor;
  var registerBlockType = blocks.registerBlockType;
  var dispatch = data.dispatch,
      select = data.select;
  var Fragment = element.Fragment;
  var RichText = blockEditor.RichText;

  var __ = Drupal.t;

  var settings = {
    title: __('Field'),
    description: __('Field block.'),
    icon: 'editor-textcolor',
    attributes: {
      tag: {
        type: 'string',
        default: 'h1'
      },
      text: {
        type: 'string'
      },
      mappingField: {
        type: 'string'
      },
      mappingAttribute: {
        type: 'string'
      },
      placeholder: {
        type: 'string',
        default: 'Insert text'
      }
    },

    edit: function edit(_ref) {
      var className = _ref.className,
          attributes = _ref.attributes,
          setAttributes = _ref.setAttributes;
      var text = attributes.text,
          tag = attributes.tag,
          placeholder = attributes.placeholder;

      return React.createElement(
        Fragment,
        null,
        React.createElement(
          'div',
          { className: className },
          React.createElement(RichText, {
            tagName: tag,
            value: text,
            placeholder: placeholder,
            onChange: function onChange(newValue) {
              return setAttributes({ text: newValue });
            }
          })
        )
      );
    },
    save: function save(_ref2) {
      var className = _ref2.className,
          attributes = _ref2.attributes;
      var text = attributes.text;


      return text;
    }
  };

  var category = {
    slug: 'drupal',
    title: __('Drupal')
  };

  var currentCategories = select('core/blocks').getCategories().filter(function (item) {
    return item.slug !== category.slug;
  });
  dispatch('core/blocks').setCategories([category].concat(_toConsumableArray(currentCategories)));

  registerBlockType(category.slug + '/field', _extends({ category: category.slug }, settings));
})(Drupal, wp);