/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

(function () {
  function registerDrupalStore(data) {
    var registerStore = data.registerStore,
        dispatch = data.dispatch;


    var DEFAULT_STATE = {
      blocks: {},
      mediaEntities: {}
    };

    return registerStore('drupal', {
      reducer: function reducer() {
        var _extends2;

        var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : DEFAULT_STATE;
        var action = arguments[1];

        switch (action.type) {
          case 'SET_BLOCK':
            return _extends({}, state, {
              blocks: _extends({}, state.blocks, (_extends2 = {}, _defineProperty(_extends2, action.item, action.settings), _defineProperty(_extends2, action.item, action.block), _extends2))
            });
          case 'SET_MEDIA_ENTITY':
            return _extends({}, state, {
              mediaEntities: _extends({}, state.mediaEntities, _defineProperty({}, action.item, action.mediaEntity))
            });
          default:
            return state;
        }
      },


      actions: {
        setBlock: function setBlock(item, settings, block) {
          return {
            type: 'SET_BLOCK',
            item: item,
            settings: settings,
            block: block
          };
        },
        setMediaEntity: function setMediaEntity(item, mediaEntity) {
          return {
            type: 'SET_MEDIA_ENTITY',
            item: item,
            mediaEntity: mediaEntity
          };
        }
      },

      selectors: {
        getBlock: function getBlock(state, item, settings) {
          var blocks = state.blocks;

          console.log(state, item, settings);
          return blocks[item];
        },
        getMediaEntity: function getMediaEntity(state, item) {
          var mediaEntities = state.mediaEntities;

          return mediaEntities[item];
        }
      },

      resolvers: {
        getBlock: function getBlock(item, settings) {
          var _this = this;

          return _asyncToGenerator(regeneratorRuntime.mark(function _callee() {
            var response, block;
            return regeneratorRuntime.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return fetch(Drupal.url('editor/blocks/load/' + item), {
                      method: 'POST',
                      headers: {
                        'Content-Type': 'application/json'
                      },
                      body: JSON.stringify(settings)
                    });

                  case 2:
                    response = _context.sent;
                    _context.next = 5;
                    return response.json();

                  case 5:
                    block = _context.sent;

                    dispatch('drupal').setBlock(item, settings, _extends({}, block, { settings: settings }));
                    return _context.abrupt('return', {
                      type: 'GET_BLOCK',
                      item: item,
                      settings: settings,
                      block: _extends({}, block, { settings: settings })
                    });

                  case 8:
                  case 'end':
                    return _context.stop();
                }
              }
            }, _callee, _this);
          }))();
        },
        getMediaEntity: function getMediaEntity(item) {
          var _this2 = this;

          return _asyncToGenerator(regeneratorRuntime.mark(function _callee2() {
            var response, mediaEntity;
            return regeneratorRuntime.wrap(function _callee2$(_context2) {
              while (1) {
                switch (_context2.prev = _context2.next) {
                  case 0:
                    _context2.next = 2;
                    return fetch(Drupal.url('editor/media/render/' + item));

                  case 2:
                    response = _context2.sent;

                    if (!response.ok) {
                      _context2.next = 10;
                      break;
                    }

                    _context2.next = 6;
                    return response.json();

                  case 6:
                    mediaEntity = _context2.sent;

                    if (!(mediaEntity && mediaEntity.view_modes)) {
                      _context2.next = 10;
                      break;
                    }

                    dispatch('drupal').setMediaEntity(item, mediaEntity);
                    return _context2.abrupt('return', {
                      type: 'GET_MEDIA_ENTITY',
                      item: item,
                      mediaEntity: mediaEntity
                    });

                  case 10:
                    if (!(response.status === 404)) {
                      _context2.next = 13;
                      break;
                    }

                    Drupal.notifyError("Media entity couldn't be found.");
                    return _context2.abrupt('return', null);

                  case 13:
                    if (response.ok) {
                      _context2.next = 16;
                      break;
                    }

                    Drupal.notifyError('An error occurred while fetching data.');
                    return _context2.abrupt('return', null);

                  case 16:
                  case 'end':
                    return _context2.stop();
                }
              }
            }, _callee2, _this2);
          }))();
        }
      }
    });
  }

  window.DrupalGutenberg = window.DrupalGutenberg || {};
  window.DrupalGutenberg.registerDrupalStore = registerDrupalStore;
})();