/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var _wp = wp,
    blocks = _wp.blocks,
    data = _wp.data,
    element = _wp.element,
    components = _wp.components,
    blockEditor = _wp.blockEditor;
var registerBlockType = blocks.registerBlockType;
var dispatch = data.dispatch,
    select = data.select;
var Fragment = element.Fragment;
var PanelBody = components.PanelBody,
    BaseControl = components.BaseControl,
    Icon = components.Icon,
    RangeControl = components.RangeControl,
    IconButton = components.IconButton,
    Toolbar = components.Toolbar,
    SelectControl = components.SelectControl;
var InnerBlocks = blockEditor.InnerBlocks,
    RichText = blockEditor.RichText,
    InspectorControls = blockEditor.InspectorControls,
    PanelColorSettings = blockEditor.PanelColorSettings,
    MediaUpload = blockEditor.MediaUpload,
    BlockControls = blockEditor.BlockControls;

var __ = Drupal.t;

var settings = {
  title: __('Gutenberg Example Block'),
  description: __('Gutenberg Example Block'),
  icon: 'welcome-learn-more',
  attributes: {
    title: {
      type: 'string'
    },
    subtitle: {
      type: 'string'
    },
    text: {
      type: 'string'
    }
  },

  edit: function edit(_ref) {
    var className = _ref.className,
        attributes = _ref.attributes,
        setAttributes = _ref.setAttributes,
        isSelected = _ref.isSelected;
    var title = attributes.title,
        subtitle = attributes.subtitle,
        text = attributes.text;


    return React.createElement(
      Fragment,
      null,
      React.createElement(
        'div',
        { className: className },
        React.createElement(
          'div',
          { className: 'column' },
          React.createElement(RichText, {
            identifier: 'title',
            tagName: 'h2',
            value: title,
            placeholder: __('Title'),
            onChange: function onChange(nextTitle) {
              setAttributes({
                title: nextTitle
              });
            },
            onSplit: function onSplit() {
              return null;
            },
            unstableOnSplit: function unstableOnSplit() {
              return null;
            }
          }),
          React.createElement(RichText, {
            identifier: 'subtitle',
            tagName: 'div',
            value: subtitle,
            placeholder: __('Subtitle'),
            onChange: function onChange(nextSubtitle) {
              setAttributes({
                subtitle: nextSubtitle
              });
            },
            onSplit: function onSplit() {
              return null;
            },
            unstableOnSplit: function unstableOnSplit() {
              return null;
            }
          }),
          React.createElement(RichText, {
            identifier: 'text',
            tagName: 'p',
            value: text,
            placeholder: __('Text'),
            onChange: function onChange(nextText) {
              setAttributes({
                text: nextText
              });
            }
          })
        ),
        React.createElement(
          'div',
          { className: 'column' },
          React.createElement(
            'div',
            { className: 'icon' },
            React.createElement(Icon, { icon: 'welcome-learn-more' })
          ),
          isSelected && React.createElement(
            'div',
            { className: 'info' },
            React.createElement(
              'p',
              null,
              'This is Gutenberg\'s example block.'
            ),
            React.createElement(
              'p',
              null,
              'To test it just fill the "fields" on the left and save.'
            )
          )
        )
      ),
      React.createElement(
        InspectorControls,
        null,
        React.createElement(
          PanelBody,
          { title: __('Block Settings') },
          React.createElement(
            'div',
            null,
            title
          )
        )
      )
    );
  },
  save: function save(_ref2) {
    var className = _ref2.className,
        attributes = _ref2.attributes;
    var title = attributes.title,
        subtitle = attributes.subtitle,
        text = attributes.text;


    return React.createElement(
      'div',
      { className: className },
      React.createElement(
        'div',
        { className: 'column' },
        title && React.createElement(
          'h2',
          null,
          title
        ),
        subtitle && React.createElement(
          'div',
          null,
          subtitle
        ),
        text && React.createElement(
          'p',
          null,
          text
        )
      ),
      React.createElement(
        'div',
        { className: 'column' },
        React.createElement(
          'div',
          { className: 'icon' },
          React.createElement(Icon, { icon: 'welcome-learn-more' })
        )
      )
    );
  }
};

var dynamicBlockSettings = {
  title: __('Gutenberg Example Dynamic Block'),
  description: __('Gutenberg example dynamic block that can be rendered server-side.'),
  icon: 'welcome-learn-more',
  attributes: {
    title: {
      type: 'string'
    }
  },

  edit: function edit(_ref3) {
    var className = _ref3.className,
        attributes = _ref3.attributes,
        setAttributes = _ref3.setAttributes,
        isSelected = _ref3.isSelected;
    var title = attributes.title;


    return React.createElement(
      'div',
      { className: className },
      React.createElement(
        'div',
        null,
        '\u2014 Hello from the Gutenberg JS editor.'
      ),
      React.createElement(
        'div',
        { className: 'dynamic-block-title' },
        React.createElement(RichText, {
          identifier: 'title',
          tagName: 'h2',
          value: title,
          placeholder: __('Title'),
          onChange: function onChange(title) {
            setAttributes({
              title: title
            });
          },
          onSplit: function onSplit() {
            return null;
          },
          unstableOnSplit: function unstableOnSplit() {
            return null;
          }
        })
      ),
      React.createElement(
        'div',
        { className: 'dynamic-block-content' },
        React.createElement(InnerBlocks, null)
      )
    );
  },
  save: function save(_ref4) {
    var className = _ref4.className,
        attributes = _ref4.attributes;
    var title = attributes.title;

    return React.createElement(InnerBlocks.Content, null);
  }
};

var category = {
  slug: 'example',
  title: __('Examples')
};

var currentCategories = select('core/blocks').getCategories().filter(function (item) {
  return item.slug !== category.slug;
});
dispatch('core/blocks').setCategories([category].concat(_toConsumableArray(currentCategories)));

registerBlockType(category.slug + '/example-block', _extends({ category: category.slug }, settings));
registerBlockType(category.slug + '/dynamic-block', _extends({ category: category.slug }, dynamicBlockSettings));