/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, window) {
  Drupal.behaviors.MediaLibraryItemSelectionClaro = {
    attach: function attach() {
      if (!once('media-library-selection-info-claro-event', 'html').length) {
        return;
      }

      $(window).on('dialog:aftercreate', function (event, dialog, $element, settings) {
        var moveCounter = function moveCounter($selectedCount, $buttonPane) {
          var $moveSelectedCount = $selectedCount.detach();
          $buttonPane.prepend($moveSelectedCount);
        };

        var $buttonPane = $element.closest('.media-library-widget-modal').find('.ui-dialog-buttonpane');

        if (!$buttonPane.length) {
          return;
        }

        var $selectedCount = $buttonPane.find('.js-media-library-selected-count');

        if ($selectedCount.length) {
          moveCounter($selectedCount, $buttonPane);
        } else {
          var selectedCountObserver = new MutationObserver(function () {
            var $selectedCountFind = $buttonPane.find('.js-media-library-selected-count');

            if ($selectedCountFind.length) {
              moveCounter($selectedCountFind, $buttonPane);
              selectedCountObserver.disconnect();
            }
          });
          selectedCountObserver.observe($buttonPane[0], {
            attributes: false,
            childList: true,
            characterData: false,
            subtree: true
          });
        }
      });
    }
  };
})(jQuery, Drupal, window);;
/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal) {
  Drupal.theme.checkbox = function () {
    return "<input type=\"checkbox\" class=\"form-checkbox\"/>";
  };
})(Drupal);;
/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal) {
  Drupal.theme.checkbox = function () {
    return '<input type="checkbox" class="form-checkbox form-boolean form-boolean--type-checkbox"/>';
  };
})(Drupal);;
/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal) {
  Drupal.behaviors.ClickToSelect = {
    attach: function attach(context) {
      $(once('media-library-click-to-select', '.js-click-to-select-trigger', context)).on('click', function (event) {
        event.preventDefault();
        var $input = $(event.currentTarget).closest('.js-click-to-select').find('.js-click-to-select-checkbox input');
        $input.prop('checked', !$input.prop('checked')).trigger('change');
      });
      $(once('media-library-click-to-select', '.js-click-to-select-checkbox input', context)).on('change', function (_ref) {
        var currentTarget = _ref.currentTarget;
        $(currentTarget).closest('.js-click-to-select').toggleClass('checked', $(currentTarget).prop('checked'));
      }).on('focus blur', function (_ref2) {
        var currentTarget = _ref2.currentTarget,
            type = _ref2.type;
        $(currentTarget).closest('.js-click-to-select').toggleClass('is-focus', type === 'focus');
      });
      $(once('media-library-click-to-select-hover', '.js-click-to-select-trigger, .js-click-to-select-checkbox', context)).on('mouseover mouseout', function (_ref3) {
        var currentTarget = _ref3.currentTarget,
            type = _ref3.type;
        $(currentTarget).closest('.js-click-to-select').toggleClass('is-hover', type === 'mouseover');
      });
    }
  };
})(jQuery, Drupal);;
(function ($, Drupal) {
  Drupal.behaviors.MediaLibrarySelectAll = {
    attach: function attach(context) {
      var $view = $('.js-media-library-view[data-view-display-id="page"]', context).once('media-library-select-all');
      if ($view.length && $view.find('.js-media-library-item').length) {
        var $checkbox = $(Drupal.theme('checkbox')).on('click', function (_ref) {
          var currentTarget = _ref.currentTarget;

          var $checkboxes = $(currentTarget).closest('.js-media-library-view').find('.js-media-library-item input[type="checkbox"]');
          $checkboxes.prop('checked', $(currentTarget).prop('checked')).trigger('change');

          var announcement = $(currentTarget).prop('checked') ? Drupal.t('All @count items selected', {
            '@count': $checkboxes.length
          }) : Drupal.t('Zero items selected');
          Drupal.announce(announcement);
        });
        var $label = $('<label class="media-library-select-all"></label>').text(Drupal.t('Select all media'));
        $label.prepend($checkbox);
        $view.find('.js-media-library-item').first().before($label);
      }

      // Media Library select
      $('.media-library-view .form-checkbox', context).on('click', function() {
        var $bulkOperations = $(this).parents('.media-library-view').find('[data-drupal-selector*="edit-header"]');

        if ($('.media-library-view .form-checkbox:checked', context).length > 0) {
          $bulkOperations.addClass('is-sticky');
        } else {
          $bulkOperations.removeClass('is-sticky');
        }
      });

      // Media Library select
      $('.media-library-view .media-library-item__click-to-select-trigger', context).on('click', function() {
        var $bulkOperations = $(this).parents('.media-library-view').find('[data-drupal-selector*="edit-header"]');

        if ($('.media-library-view .form-checkbox:checked', context).length > 0) {
          $bulkOperations.addClass('is-sticky');
        } else {
          $bulkOperations.removeClass('is-sticky');
        }

        var selectAll = $('.media-library-select-all input');
        var checkboxes = $('.media-library-view .media-library-item input');

        if (selectAll.filter(':checked').length === 1 && checkboxes.length !== checkboxes.filter(':checked').length) {
          selectAll.prop('checked', false).trigger('change');
        }
      });
    }
  };
})(jQuery, Drupal);
;
/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, window, _ref) {
  var tabbable = _ref.tabbable;
  Drupal.MediaLibrary = {
    currentSelection: []
  };

  Drupal.AjaxCommands.prototype.updateMediaLibrarySelection = function (ajax, response, status) {
    Object.values(response.mediaIds).forEach(function (value) {
      Drupal.MediaLibrary.currentSelection.push(value);
    });
  };

  Drupal.behaviors.MediaLibraryTabs = {
    attach: function attach(context) {
      var $menu = $('.js-media-library-menu');
      $(once('media-library-menu-item', $menu.find('a'))).on('keypress', function (e) {
        if (e.which === 32) {
          e.preventDefault();
          e.stopPropagation();
          $(e.currentTarget).trigger('click');
        }
      }).on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var ajaxObject = Drupal.ajax({
          wrapper: 'media-library-content',
          url: e.currentTarget.href,
          dialogType: 'ajax',
          progress: {
            type: 'fullscreen',
            message: Drupal.t('Please wait...')
          }
        });

        ajaxObject.success = function (response, status) {
          var _this = this;

          if (this.progress.element) {
            $(this.progress.element).remove();
          }

          if (this.progress.object) {
            this.progress.object.stopMonitoring();
          }

          $(this.element).prop('disabled', false);
          Object.keys(response || {}).forEach(function (i) {
            if (response[i].command && _this.commands[response[i].command]) {
              _this.commands[response[i].command](_this, response[i], status);
            }
          });
          var mediaLibraryContent = document.getElementById('media-library-content');

          if (mediaLibraryContent) {
            var tabbableContent = tabbable(mediaLibraryContent);

            if (tabbableContent.length) {
              tabbableContent[0].focus();
            }
          }

          this.settings = null;
        };

        ajaxObject.execute();
        $menu.find('.active-tab').remove();
        $menu.find('a').removeClass('active');
        $(e.currentTarget).addClass('active').html(Drupal.t('<span class="visually-hidden">Show </span>@title<span class="visually-hidden"> media</span><span class="active-tab visually-hidden"> (selected)</span>', {
          '@title': $(e.currentTarget).data('title')
        }));
        Drupal.announce(Drupal.t('Showing @title media.', {
          '@title': $(e.currentTarget).data('title')
        }));
      });
    }
  };
  Drupal.behaviors.MediaLibraryViewsDisplay = {
    attach: function attach(context) {
      var $view = $(context).hasClass('.js-media-library-view') ? $(context) : $('.js-media-library-view', context);
      $view.closest('.views-element-container').attr('id', 'media-library-view');
      $(once('media-library-views-display-link', '.views-display-link-widget, .views-display-link-widget_table', context)).on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var $link = $(e.currentTarget);
        var loadingAnnouncement = '';
        var displayAnnouncement = '';
        var focusSelector = '';

        if ($link.hasClass('views-display-link-widget')) {
          loadingAnnouncement = Drupal.t('Loading grid view.');
          displayAnnouncement = Drupal.t('Changed to grid view.');
          focusSelector = '.views-display-link-widget';
        } else if ($link.hasClass('views-display-link-widget_table')) {
          loadingAnnouncement = Drupal.t('Loading table view.');
          displayAnnouncement = Drupal.t('Changed to table view.');
          focusSelector = '.views-display-link-widget_table';
        }

        var ajaxObject = Drupal.ajax({
          wrapper: 'media-library-view',
          url: e.currentTarget.href,
          dialogType: 'ajax',
          progress: {
            type: 'fullscreen',
            message: loadingAnnouncement || Drupal.t('Please wait...')
          }
        });

        if (displayAnnouncement || focusSelector) {
          var success = ajaxObject.success;

          ajaxObject.success = function (response, status) {
            success.bind(this)(response, status);

            if (focusSelector) {
              $(focusSelector).focus();
            }

            if (displayAnnouncement) {
              Drupal.announce(displayAnnouncement);
            }
          };
        }

        ajaxObject.execute();

        if (loadingAnnouncement) {
          Drupal.announce(loadingAnnouncement);
        }
      });
    }
  };
  Drupal.behaviors.MediaLibraryItemSelection = {
    attach: function attach(context, settings) {
      var $form = $('.js-media-library-views-form, .js-media-library-add-form', context);
      var currentSelection = Drupal.MediaLibrary.currentSelection;

      if (!$form.length) {
        return;
      }

      var $mediaItems = $('.js-media-library-item input[type="checkbox"]', $form);

      function disableItems($items) {
        $items.prop('disabled', true).closest('.js-media-library-item').addClass('media-library-item--disabled');
      }

      function enableItems($items) {
        $items.prop('disabled', false).closest('.js-media-library-item').removeClass('media-library-item--disabled');
      }

      function updateSelectionCount(remaining) {
        var selectItemsText = remaining < 0 ? Drupal.formatPlural(currentSelection.length, '1 item selected', '@count items selected') : Drupal.formatPlural(remaining, '@selected of @count item selected', '@selected of @count items selected', {
          '@selected': currentSelection.length
        });
        $('.js-media-library-selected-count').html(selectItemsText);
      }

      $(once('media-item-change', $mediaItems)).on('change', function (e) {
        var id = e.currentTarget.value;
        var position = currentSelection.indexOf(id);

        if (e.currentTarget.checked) {
          if (position === -1) {
            currentSelection.push(id);
          }
        } else if (position !== -1) {
          currentSelection.splice(position, 1);
        }

        $form.find('#media-library-modal-selection').val(currentSelection.join()).trigger('change');
        $('.js-media-library-add-form-current-selection').val(currentSelection.join());
      });
      $(once('media-library-selection-change', $form.find('#media-library-modal-selection'))).on('change', function (e) {
        updateSelectionCount(settings.media_library.selection_remaining);

        if (currentSelection.length === settings.media_library.selection_remaining) {
          disableItems($mediaItems.not(':checked'));
          enableItems($mediaItems.filter(':checked'));
        } else {
          enableItems($mediaItems);
        }
      });
      currentSelection.forEach(function (value) {
        $form.find("input[type=\"checkbox\"][value=\"".concat(value, "\"]")).prop('checked', true).trigger('change');
      });

      if (!once('media-library-selection-info', 'html').length) {
        return;
      }

      $(window).on('dialog:aftercreate', function () {
        var $buttonPane = $('.media-library-widget-modal .ui-dialog-buttonpane');

        if (!$buttonPane.length) {
          return;
        }

        $buttonPane.append(Drupal.theme('mediaLibrarySelectionCount'));
        updateSelectionCount(settings.media_library.selection_remaining);
      });
    }
  };
  Drupal.behaviors.MediaLibraryModalClearSelection = {
    attach: function attach() {
      if (!once('media-library-clear-selection', 'html').length) {
        return;
      }

      $(window).on('dialog:afterclose', function () {
        Drupal.MediaLibrary.currentSelection = [];
      });
    }
  };

  Drupal.theme.mediaLibrarySelectionCount = function () {
    return "<div class=\"media-library-selected-count js-media-library-selected-count\" role=\"status\" aria-live=\"polite\" aria-atomic=\"true\"></div>";
  };
})(jQuery, Drupal, window, window.tabbable);;
/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  Drupal.Views = {};

  Drupal.Views.parseQueryString = function (query) {
    var args = {};
    var pos = query.indexOf('?');

    if (pos !== -1) {
      query = query.substring(pos + 1);
    }

    var pair;
    var pairs = query.split('&');

    for (var i = 0; i < pairs.length; i++) {
      pair = pairs[i].split('=');

      if (pair[0] !== 'q' && pair[1]) {
        args[decodeURIComponent(pair[0].replace(/\+/g, ' '))] = decodeURIComponent(pair[1].replace(/\+/g, ' '));
      }
    }

    return args;
  };

  Drupal.Views.parseViewArgs = function (href, viewPath) {
    var returnObj = {};
    var path = Drupal.Views.getPath(href);
    var viewHref = Drupal.url(viewPath).substring(drupalSettings.path.baseUrl.length);

    if (viewHref && path.substring(0, viewHref.length + 1) === "".concat(viewHref, "/")) {
      returnObj.view_args = decodeURIComponent(path.substring(viewHref.length + 1, path.length));
      returnObj.view_path = path;
    }

    return returnObj;
  };

  Drupal.Views.pathPortion = function (href) {
    var protocol = window.location.protocol;

    if (href.substring(0, protocol.length) === protocol) {
      href = href.substring(href.indexOf('/', protocol.length + 2));
    }

    return href;
  };

  Drupal.Views.getPath = function (href) {
    href = Drupal.Views.pathPortion(href);
    href = href.substring(drupalSettings.path.baseUrl.length, href.length);

    if (href.substring(0, 3) === '?q=') {
      href = href.substring(3, href.length);
    }

    var chars = ['#', '?', '&'];

    for (var i = 0; i < chars.length; i++) {
      if (href.indexOf(chars[i]) > -1) {
        href = href.substr(0, href.indexOf(chars[i]));
      }
    }

    return href;
  };
})(jQuery, Drupal, drupalSettings);;
/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.ViewsAjaxView = {};

  Drupal.behaviors.ViewsAjaxView.attach = function (context, settings) {
    if (settings && settings.views && settings.views.ajaxViews) {
      var ajaxViews = settings.views.ajaxViews;
      Object.keys(ajaxViews || {}).forEach(function (i) {
        Drupal.views.instances[i] = new Drupal.views.ajaxView(ajaxViews[i]);
      });
    }
  };

  Drupal.behaviors.ViewsAjaxView.detach = function (context, settings, trigger) {
    if (trigger === 'unload') {
      if (settings && settings.views && settings.views.ajaxViews) {
        var ajaxViews = settings.views.ajaxViews;
        Object.keys(ajaxViews || {}).forEach(function (i) {
          var selector = ".js-view-dom-id-".concat(ajaxViews[i].view_dom_id);

          if ($(selector, context).length) {
            delete Drupal.views.instances[i];
            delete settings.views.ajaxViews[i];
          }
        });
      }
    }
  };

  Drupal.views = {};
  Drupal.views.instances = {};

  Drupal.views.ajaxView = function (settings) {
    var selector = ".js-view-dom-id-".concat(settings.view_dom_id);
    this.$view = $(selector);
    var ajaxPath = drupalSettings.views.ajax_path;

    if (ajaxPath.constructor.toString().indexOf('Array') !== -1) {
      ajaxPath = ajaxPath[0];
    }

    var queryString = window.location.search || '';

    if (queryString !== '') {
      queryString = queryString.slice(1).replace(/q=[^&]+&?|&?render=[^&]+/, '');

      if (queryString !== '') {
        queryString = (/\?/.test(ajaxPath) ? '&' : '?') + queryString;
      }
    }

    this.element_settings = {
      url: ajaxPath + queryString,
      submit: settings,
      setClick: true,
      event: 'click',
      selector: selector,
      progress: {
        type: 'fullscreen'
      }
    };
    this.settings = settings;
    this.$exposed_form = $("form#views-exposed-form-".concat(settings.view_name.replace(/_/g, '-'), "-").concat(settings.view_display_id.replace(/_/g, '-')));
    once('exposed-form', this.$exposed_form).forEach($.proxy(this.attachExposedFormAjax, this));
    once('ajax-pager', this.$view.filter($.proxy(this.filterNestedViews, this))).forEach($.proxy(this.attachPagerAjax, this));
    var selfSettings = $.extend({}, this.element_settings, {
      event: 'RefreshView',
      base: this.selector,
      element: this.$view.get(0)
    });
    this.refreshViewAjax = Drupal.ajax(selfSettings);
  };

  Drupal.views.ajaxView.prototype.attachExposedFormAjax = function () {
    var that = this;
    this.exposedFormAjax = [];
    $('input[type=submit], button[type=submit], input[type=image]', this.$exposed_form).not('[data-drupal-selector=edit-reset]').each(function (index) {
      var selfSettings = $.extend({}, that.element_settings, {
        base: $(this).attr('id'),
        element: this
      });
      that.exposedFormAjax[index] = Drupal.ajax(selfSettings);
    });
  };

  Drupal.views.ajaxView.prototype.filterNestedViews = function () {
    return !this.$view.parents('.view').length;
  };

  Drupal.views.ajaxView.prototype.attachPagerAjax = function () {
    this.$view.find('ul.js-pager__items > li > a, th.views-field a, .attachment .views-summary a').each($.proxy(this.attachPagerLinkAjax, this));
  };

  Drupal.views.ajaxView.prototype.attachPagerLinkAjax = function (id, link) {
    var $link = $(link);
    var viewData = {};
    var href = $link.attr('href');
    $.extend(viewData, this.settings, Drupal.Views.parseQueryString(href), Drupal.Views.parseViewArgs(href, this.settings.view_base_path));
    var selfSettings = $.extend({}, this.element_settings, {
      submit: viewData,
      base: false,
      element: link
    });
    this.pagerAjax = Drupal.ajax(selfSettings);
  };

  Drupal.AjaxCommands.prototype.viewsScrollTop = function (ajax, response) {
    var offset = $(response.selector).offset();
    var scrollTarget = response.selector;

    while ($(scrollTarget).scrollTop() === 0 && $(scrollTarget).parent()) {
      scrollTarget = $(scrollTarget).parent();
    }

    if (offset.top - 10 < $(scrollTarget).scrollTop()) {
      $(scrollTarget).animate({
        scrollTop: offset.top - 10
      }, 500);
    }
  };
})(jQuery, Drupal, drupalSettings);;
